#include <windows.h>
#include <gl/gl.h>
#include <time.h>
#include "scrnsave.h"
#include "tetrisAI.h"

#define szAppName	"Bad Tetris AI"
#define szAuthor	"Written by Darryll Sulymka,  2003"
#define szPreview	"Bad Tetris AI"

void EnableOpenGL (HWND hWnd, HDC *hDC, HGLRC *hRC);
void DisableOpenGL (HWND hWnd, HDC hDC, HGLRC hRC);
void RotatePiece();
void right();
void left();
int Update();
void NextPiece();

/**************************
 * Globle for the lazy
 *     Programmer
 **************************/
 
PIECE currentPiece;
PIECE nextPiece;
int board[10][22];

LRESULT WINAPI ScreenSaverProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	static int i,j;
	static HDC hDC,hdc;
	static PAINTSTRUCT ps;
    static HGLRC hRC;
    static float theta = 0.0f;
    static int x,y;
	static int tboard [10] [22];
	static float red,blue,green;
	static int color,count=0;
    static float direct =1.0;
	switch(message)
	{
	case WM_CREATE:
		srand(time(0));
        for(i=0;i<10;i++)
            for(j=0;j<22;j++)
                board [i][j] = 0;
                
	    NextPiece();
	    NextPiece();
        SetTimer (hWnd,1,40,NULL);
        SetTimer (hWnd,2,20,NULL);
		thinkAI(board, &currentPiece);
		color = 0;
		blue = 1.0f;
		red = 0.0f;
		green = 0.0f;
	    EnableOpenGL (hWnd, &hDC, &hRC);
		break;

    case WM_DESTROY:
		KillTimer (hWnd,1);
		KillTimer (hWnd,2);
	    DisableOpenGL (hWnd, hDC, hRC);		
		PostQuitMessage(0);
		break;

	case WM_TIMER:
    	switch(wParam){
		  case 1:
			if(Update()){/*Game Over man*/
				for(i=0;i<10;i++)
            		for(j=0;j<22;j++)
			             board [i][j] = 0;
	
            	NextPiece();
            	NextPiece();
       			thinkAI(board, &currentPiece);	
			}
			break;
		  case 2:
			switch (makeMoveAI(&currentPiece)){
				case AI_NO_MOVE:
					//no move
					break;
				case AI_LEFT:
						left();
					break;
				case AI_RIGHT:
					right();
					break;
				case AI_ROTATE:
					RotatePiece();
					break;
			}
			break;
	   }
	   
	   switch (color){
            case 0:   
                if (blue<=0.0f)
                    color = 1;
                else {
                    blue -= 0.01;
                    red += 0.01f;
                }
                break;
            case 1:
                if (red<=0.0f)
                    color = 2;
                else {
                    red -= 0.01;
                    green += 0.01f;
                }
                break;
            case 2:
                if (green<=0.0f)
                    color = 0;
                else {
                    green -= 0.01;
                    blue += 0.01f;
                }
                break;
        }

	   for (x=0;x<10;x++)
	       for (y=0;y<22;y++)
               tboard[x][y]=board[x][y];

        for (x=0;x<4;x++)
            for (y=0;y<4;y++)
                if ((currentPiece.x+x<10)&&(currentPiece.y+y<22)&&(currentPiece.piece[x][y]!=0))
                    tboard[x+currentPiece.x][y+currentPiece.y]=currentPiece.piece[x][y];

        glClearColor (0.0f, 0.0f, 0.0f, 0.0f);
        glClear (GL_COLOR_BUFFER_BIT);

        glPushMatrix ();
        glRotatef (theta, direct, direct, direct);
        for(y=19;y>=0;y--){
            for(x=0;x<10;x++)
                if (tboard[x][y+2]!=0){
                    glBegin (GL_POLYGON);
                        glColor3f (red, blue, green);
                        glVertex2f(-0.47+0.09*x, 0.95-0.1*y);
                        glColor3f (red/2, blue/2, green/2);
                        glVertex2f(-0.47+0.09*x+0.09, 0.95-0.1*y);
                        glColor3f (red*0.75, blue*0.75, green*0.75);
                        glVertex2f(-0.47+0.09*x+0.09, 0.95-0.1*y+0.1);
                        glColor3f (1.0f, 1.0f, 1.0f);
                        glVertex2f(-0.47+0.09*x, 0.95-0.1*y+0.1);
                    glEnd ();
				}
    	}
        glPopMatrix ();
                
                
        SwapBuffers (hDC);
        
  /*      SetBkMode(hDC,TRANSPARENT);
   		SetTextColor(hDC, RGB(120, 120, 120));
        TextOut(hDC, 0, 25, "Bad AI", strlen("Bad AI"));
		TextOut(hDC, 0, 40, "Written by Darryll Sulymka,  2001",
                strlen("Written by Darryll Sulymka,  2001"));*/
                
        theta += 1.0f;
     //   count++;
        if (count == 1000){
            direct*=-1;
            count = 0;
        }
        break;

	case WM_PAINT:
    	hdc = BeginPaint(hWnd, &ps);
    	EndPaint(hWnd, &ps);
		break;

    default: 
		return DefScreenSaverProc(hWnd, message, wParam, lParam);
	}
	
	return 0;
}

BOOL WINAPI ScreenSaverConfigureDialog(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	return FALSE;
}

BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
	return TRUE;
}

void
EnableOpenGL (HWND hWnd, HDC *hDC, HGLRC *hRC)
{
    PIXELFORMATDESCRIPTOR pfd;
    int iFormat;

    /* get the device context (DC) */
    *hDC = GetDC (hWnd);

    /* set the pixel format for the DC */
    ZeroMemory (&pfd, sizeof (pfd));
    pfd.nSize = sizeof (pfd);
    pfd.nVersion = 1;
    pfd.dwFlags = PFD_DRAW_TO_WINDOW | 
      PFD_SUPPORT_OPENGL | PFD_DOUBLEBUFFER;
    pfd.iPixelType = PFD_TYPE_RGBA;
    pfd.cColorBits = 24;
    pfd.cDepthBits = 16;
    pfd.iLayerType = PFD_MAIN_PLANE;
    iFormat = ChoosePixelFormat (*hDC, &pfd);
    SetPixelFormat (*hDC, iFormat, &pfd);

    /* create and enable the render context (RC) */
    *hRC = wglCreateContext( *hDC );
    wglMakeCurrent( *hDC, *hRC );

}


/******************
 * Disable OpenGL
 *
 ******************/

void
DisableOpenGL (HWND hWnd, HDC hDC, HGLRC hRC)
{
    wglMakeCurrent (NULL, NULL);
    wglDeleteContext (hRC);
    ReleaseDC (hWnd, hDC);
}

void NextPiece()
{
	int x,y,i,j,temp;

	currentPiece=nextPiece;

	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			nextPiece.piece[x][y]=0;
    temp = rand()%7+1;
//	temp = 5;
	switch (temp){
		case 1:     //line
			for (x=0;x<4;x++)
				nextPiece.piece[x][1]=2;
			nextPiece.type = 1;
			break;
		case 2:       //L
			for (x=1;x<4;x++)
				nextPiece.piece[x][2]=3;
			nextPiece.piece[1][1]=3;
			nextPiece.type = 2;
			break;
		case 3:       //BL
			for (x=1;x<4;x++)
				nextPiece.piece[x][2]=4;
			nextPiece.piece[2][1]=4;
			nextPiece.type = 2;
			break;
		case 4:      //T
			for (x=1;x<4;x++)
				nextPiece.piece[x][2]=5;
			nextPiece.piece[3][1]=5;
			nextPiece.type = 2;
			break;
		case 5:  // Square
			for (i=1;i<3;i++)
				for (j=1;j<3;j++)
					nextPiece.piece[i][j]=6;
				nextPiece.type = 3;
		break;
		case 6: // z
			for (i=0;i<2;i++){
				nextPiece.piece[i][1]=7;
				nextPiece.piece[i+1][2]=7;
			}
			nextPiece.type = 1;
		break;
		case 7:// s
			for (i=0;i<2;i++){
				nextPiece.piece[i+1][1]=8;
				nextPiece.piece[i][2]=8;
			}
			nextPiece.type = 1;
		break;
	}
	currentPiece.x=3;
	currentPiece.y=0;
}

int Update()
{
	int x,y,i,change_all=0,game_over=0,loop=1,line=0;
	int tboard [10] [22];

	for (x=0;x<10;x++)
		for (y=0;y<22;y++)
			tboard[x][y]=board[x][y];

	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			if((currentPiece.piece[x][y]!=0)&&(currentPiece.y+y==21))
				change_all=1;

	if (change_all!=1)
		for (x=0;x<4;x++)
			for (y=0;y<4;y++)
				if ((currentPiece.x+x<10)&&(currentPiece.y+y+1<22)&&(currentPiece.piece[x][y]!=0))
					if (tboard[x+currentPiece.x][y+currentPiece.y+1]!=0)
						change_all=1;

	if (change_all==1){
		for (x=0;x<4;x++)
			for (y=0;y<4;y++)
				if ((currentPiece.x+x<10)&&(currentPiece.y+y>=0)&&(currentPiece.piece[x][y]!=0))
					tboard[x+currentPiece.x][y+currentPiece.y]=currentPiece.piece[x][y];

		for (x=0;x<10;x++)
			for (y=0;y<22;y++)
				board[x][y] = tboard[x][y];
		NextPiece();
   }

	for (x=0;x<10;x++)
		for (y=0;y<3;y++)
			if (tboard[x][y]!=0)
				game_over=1;

	y=21;

	if ((change_all==1)&&(game_over!=1))
		while(loop){
			if ((board[0][y]!=0)&&(board[1][y]!=0)&&(board[2][y]!=0)&&(board[3][y]!=0))
				if ((board[4][y]!=0)&&(board[5][y]!=0)&&(board[6][y]!=0)&&(board[7][y]!=0))
					if ((board[8][y]!=0)&&(board[9][y]!=0)){
						for (x=0;x<10;x++)
							for (i=y-1;i>0;i--){
								board[x][i+1]=board[x][i];
								board[x][i]=0;
							}
							y++;
							line++;
					}
			y--;
			if (y==0)
				loop=0;
		}

	if(change_all==0)
		currentPiece.y++;
	else
		thinkAI(board, &currentPiece);

	return game_over;
}

void left()
{
	int x,y,can_move=1;
	int tboard [10] [22];

	for (x=0;x<10;x++)
		for (y=0;y<22;y++)
			tboard [x][y] = board [x][y];
	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			if ((currentPiece.x+x<10)&&(currentPiece.y+y<22)&&(currentPiece.piece[x][y]))
				tboard[x+currentPiece.x][y+currentPiece.y]=1;

	for (y=0;y<22;y++)
		if (tboard[0][y]==1)
			can_move=0;

	for (x=1;x<10;x++)
		for (y=0;y<22;y++)
			if ((tboard[x][y]==1)&&(tboard[x-1][y]>1))
				can_move=0;

	if (can_move==1)
		currentPiece.x--;
}

void right()
{
	int x,y,can_move=1;
	int tboard [10] [22];

	for (x=0;x<10;x++)
		for (y=0;y<22;y++)
			tboard [x][y] = board [x][y];

	for (x=0;x<4;x++)
		for (y=0;y<4;y++)
			if ((currentPiece.x+x<10)&&(currentPiece.y+y<22)&&(currentPiece.piece[x][y]))
				tboard[x+currentPiece.x][y+currentPiece.y]=1;

	for (y=0;y<22;y++)
		if (tboard[9][y]==1)
			can_move=0;

	for (x=0;x<9;x++)
		for (y=0;y<22;y++)
			if ((tboard[x][y]==1)&&(tboard[x+1][y]>1))
				can_move=0;

	if (can_move==1)
		currentPiece.x++;
}

void RotatePiece()
{
	int x,y,dir=1,can_rotate=1;
	char temp [4][4];

	for(x=0;x<4;x++)
		for(y=0;y<4;y++)
			temp[x][y] = 0;

	switch(currentPiece.type) {
		case 1:
			if (dir==1) {
				for(x=0;x<4;x++)
					for(y=0;y<4;y++)
						temp[y][3-x] = currentPiece.piece[x][y];
			}
			else if (dir==2) {
				for(x=0;x<4;x++)
					for(y=0;y<4;y++)
						temp[3-y][x] = currentPiece.piece[x][y];
			}
			break;
		case 2:
			if (dir==1) {
				for(x=1;x<4;x++)
					for(y=0;y<3;y++)
						temp[y+1][3-x] = currentPiece.piece[x][y];
			}
			else if (dir==2) {
				for(x=1;x<4;x++)
					for(y=0;y<3;y++)
						temp[3-y][x-1] = currentPiece.piece[x][y];
			}
			break;
		case 3:
			can_rotate=0;
			break;
	}

	for(x=0;x<4;x++)
		for(y=0;y<4;y++)
			if (temp[x][y]!=0)
				if((x+currentPiece.x<0)||(x+currentPiece.x>9)||(y+currentPiece.y>21)||
					(board[x+currentPiece.x][y+currentPiece.y]!=0))
					can_rotate=0;
	if (can_rotate==1){
		for(x=0;x<4;x++)
			for(y=0;y<4;y++)
				currentPiece.piece[x][y] = temp[x][y];

	}
}
